% Mikoaj Czajkowski , Wiktor Budziski 
% "Simulation error in maximum likelihood estimation of discrete choice
% models"
%
% Online materials

% Script calculates Minimum tolerance level, which is later used for regressions and recommendations in the paper 
% 2019-03-08

% INPUT
% Simulation results estimated with 1000 repetitions for designs with 5 attributes (folder '1000')
% Simulation results estimated with 100 repetitions for designs with 5 attributes (folder 'Rest'). 
% Simulation results estimated with 1000 repetitions for designs with 10 attributes (folder '1000_10')
% MTL function 
% Tools package (https://github.com/czaj/Ttools)

% Output:
% File: MTL_results05 or MTL_results01 (depending on Alpha specified below)

clear
clc

Alpha = 0.05; % Confidence level for MTL
Directory1 = 'C:\Users\wbudzinski\Documents\Drawy\Codes\1000'; % Directory to the first folder
Directory2 = 'C:\Users\wbudzinski\Documents\Drawy\Codes\Rest'; % Directory to the second folder
Directory3 = 'C:\Users\wbudzinski\Documents\Drawy\Codes\1000_10'; % Directory to the third folder

Output = NaN(4,13,27,2, 1 + 20 + 20 +5+1); 
    % 4 types of draws, 13 numbers of draws, 27 designs, 5 attributes or 10
    % attributes
    % LL, 20 for Betas, 20 for Z stats
    % Explanatory: Type of draws, Number of draws, Design, NCT, NP, No. of
    % attributes
    
    
NaNMiss = zeros(4,7,27);
NaNno = zeros(10,4,10,27); % How many times there are NaN's instead of st. errors


Output(1,:,:,:,42) = 1; % PMC
Output(2,:,:,:,42) = 2; % MLHS
Output(3,:,:,:,42) = 3; % Halt
Output(4,:,:,:,42) = 4; % Sob

Output(:,:,1:9,:,43) = 1; % MNL
Output(:,:,10:18,:,43) = 2; % MXL
Output(:,:,19:27,:,43) = 3; % OOD


Tmp = [100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000]; 
for i = 1:13
    Output(:,i,:,:,44) = Tmp(i); 
end
% NCT
Output(:,:,[1:3 10:12 19:21],:,45) = 4; %
Output(:,:,[4:6 13:15 22:24],:,45) = 8; %
Output(:,:,[7:9 16:18 25:27],:,45) = 12; %
% NP
Output(:,:,[1:3:25],:,46) = 400; %
Output(:,:,[2:3:26],:,46) = 800; %
Output(:,:,[3:3:27],:,46) = 1200; %

% NVarA
Output(:,:,:,1,47) = 5; %
Output(:,:,:,2,47) = 10; %

%% First loop
cd(Directory1) % Directory for files with simulation results
files = dir('*.mat');
d = 0;
for file = files'
    
   load(file.name);
   file.name
   d = d+1;
   
   % Calculations for LL
    for i = 1:4 % Type of draws
        for j = 1:7 % Different number of draws
             if any(isnan(SimResults.LL(:,j,i)))
                 Output(i,j,d,1) = NaN;
                 NaNMiss(i,j,d) = 1;
             else
                [theta] = MTL([SimResults.LL(:,j,i), SimResults.LL(:,j,i)], [var(SimResults.LL(:,j,i)),0;0,var(SimResults.LL(:,j,i))], chi2inv(0.95,1)/4, 2,[],[], Alpha);
                 Output(i,j,d,1,1) = theta;
             end
        end
    end 
    
    % Calculations for Betas & Z stats
    
    for i = 1:4 % Type of draws
        for j = 1:7 % Different number of draws
             for k = 1:10 %
                 if any(isnan(SimResults.LL(:,j,i)))
                     Output(i,j,d,1,1+k) = NaN;
                 else
                     [theta] = MTL([SimResults.b(k,:,j,i)', SimResults.b(k,:,j,i)'], [1,0;0,1], 0.5, 2,[],[],  Alpha);
                     Output(i,j,d,1,1+k) = theta;
                 end
                 if any(isnan(SimResults.LL(:,j,i)))
                     Output(i,j,d,1,21+k) = NaN;
                 else
                     tmpx = isnan(SimResults.std(k,:,j,i));
                     NaNno(k,i,j,d) = sum(tmpx);
                     [theta] = MTL([SimResults.b(k,~tmpx,j,i)'./SimResults.std(k,~tmpx,j,i)', SimResults.b(k,~tmpx,j,i)'./SimResults.std(k,~tmpx,j,i)'], [1,0;0,1], 1.5, 2,[],[],  Alpha);
                     Output(i,j,d,1,21+k) = theta;
                 end
                 
             end
        end
        
    end
end

%% Second loop
cd(Directory2) % Directory for files with the rest of simulation results (with 100 repetitions)
files = dir('*.mat');
d = 0;

for file = files'
    load(file.name);
    file.name
     d = d+1;
   
   % Calculations for LL
   if d < 10
        for i = 1:4 % Type of draws
            for j = 8:10 % Different number of draws
                if i == 1 || i == 4
                     if any(isnan(SimResults.LL(:,j,i)))
                         Output(i,j,9+d,1,1) = NaN;
                         NaNMiss(i,j,9+d) = 1;
                     else
                        [theta] = MTL([SimResults.LL(:,j,i), SimResults.LL(:,j,i)], [var(SimResults.LL(:,j,i)),0;0,var(SimResults.LL(:,j,i))], chi2inv(0.95,1)/4, 2,[],[],  Alpha);
                         Output(i,j,9+d,1,1) = theta;
                         NaNMiss(i,j,9+d) = 0;
                     end
                end
            end
        end 

        % Calculations for Betas & Z stats

        for i = 1:4 % Type of draws
            for j = 8:10 % Different number of draws
                if i == 1 || i == 4
                 for k = 1:10 %
                     if any(isnan(SimResults.LL(:,j,i)))
                         Output(i,j,9+d,1,1+k) = NaN;
                     else
                         [theta] = MTL([SimResults.b(k,:,j,i)', SimResults.b(k,:,j,i)'], [1,0;0,1], 0.5, 2,[],[],  Alpha);
                         Output(i,j,9+d,1,1+k) = theta;
                     end
                     if any(isnan(SimResults.LL(:,j,i)))
                         Output(i,j,9+d,1,21+k) = NaN;
                     else
                         tmpx = isnan(SimResults.std(k,:,j,i));
                         NaNno(k,i,j,9+d) = sum(tmpx);
                         [theta] = MTL([SimResults.b(k,~tmpx,j,i)'./SimResults.std(k,~tmpx,j,i)', SimResults.b(k,~tmpx,j,i)'./SimResults.std(k,~tmpx,j,i)'], [1,0;0,1], 1.5, 2,[],[],  Alpha);
                         Output(i,j,9+d,1,21+k) = theta;
                     end

                 end
                end
            end

        end
   elseif d == 10
       [theta] =  MTL([SimResults.LL(:,13,1), SimResults.LL(:,13,1)], [1,0;0,1], chi2inv(0.95,1)/4, 2,[],[],  Alpha);
        Output(1,13,10,1,1) = theta;
        
        for k = 1:10
            [theta] = MTL([SimResults.b(k,:,13,1)', SimResults.b(k,:,13,1)'], [1,0;0,1], 0.5, 2,[],[],  Alpha);
            Output(1,13,10,1,1+k) = theta;
            [theta] = MTL([SimResults.b(k,~tmpx,13,1)'./SimResults.std(k,~tmpx,13,1)', SimResults.b(k,~tmpx,13,1)'./SimResults.std(k,~tmpx,13,1)'], [1,0;0,1], 1.5, 2,[],[],  Alpha);
            Output(1,13,10,1,21+k) = theta;
        end
   elseif d == 11
       for j = 8:12
           [theta] =  MTL([SimResults.LL(:,j,1), SimResults.LL(:,j,1)], [1,0;0,1], chi2inv(0.95,1)/4, 2,[],[],  Alpha);
            Output(1,j,10,1,1) = theta;
       end 
       for j = 8:12
        for k = 1:10
            [theta] = MTL([SimResults.b(k,:,j,1)', SimResults.b(k,:,j,1)'], [1,0;0,1], 0.5, 2,[],[],  Alpha);
            Output(1,j,10,1,1+k) = theta;
            [theta] = MTL([SimResults.b(k,~tmpx,j,1)'./SimResults.std(k,~tmpx,j,1)', SimResults.b(k,~tmpx,j,1)'./SimResults.std(k,~tmpx,j,1)'], [1,0;0,1], 1.5, 2,[],[],  Alpha);
            Output(1,j,10,1,21+k) = theta;
        end
       end
   elseif d == 12
       for j = 1:3
           [theta] =  MTL([SimResults.LL(:,j,4), SimResults.LL(:,j,4)], [1,0;0,1], chi2inv(0.95,1), 2,[],[],  Alpha);
            Output(4,10+j,10,1,1) = theta;
       end 
       for j = 1:3
        for k = 1:10
            [theta] = MTL([SimResults.b(k,:,j,4)', SimResults.b(k,:,j,4)'], [1,0;0,1], 1, 2,[],[],  Alpha);
            Output(4,10+j,10,1,1+k) = theta;
            [theta] = MTL([SimResults.b(k,~tmpx,j,4)'./SimResults.std(k,~tmpx,j,4)', SimResults.b(k,~tmpx,j,4)'./SimResults.std(k,~tmpx,j,4)'], [1,0;0,1], 2, 2,[],[],  Alpha);
            Output(4,10+j,10,1,21+k) = theta;
        end
       end
       
   end
end

%% Third loop

cd(Directory3) % Directory for files with simulation results
NaNMiss2 = zeros(4,10,9); % How many cases are still missing
files = dir('*.mat');
for file = files'
    
   load(file.name);
   file.name
   % Calculations for LL
    for i = 1:4 % Type of draws
        for j = 1:10 % Different number of draws
             LL_indx =SimResults.LL(:,j,i) ~= 0;
             LL_tmp = SimResults.LL(LL_indx,j,i);
             NaNMiss2(i,j,d) = length(LL_indx) - sum(LL_indx);
             if NaNMiss2(i,j,d) ~= 1000
                 [theta] = MTL([LL_tmp, LL_tmp], [var(LL_tmp),0;0,var(LL_tmp)], chi2inv(0.95,1)/4, 2,[],[],  Alpha);
                  Output(i,j,9+d,2,1) = theta;
             else
                 Output(i,j,9+d,2,1) = NaN; % If there are no simulation results
             end
        end
    end 
    % Calculations for Betas & Z stats
    
    for i = 1:4 % Type of draws
        for j = 1:10 % Different number of draws
             for k = 1:20 %
                 if NaNMiss2(i,j,d) ~= 1000
                     [theta] = MTL([SimResults.b(k,LL_indx,j,i)', SimResults.b(k,LL_indx,j,i)'], [1,0;0,1], 0.5, 2,[],[],  Alpha);
                     Output(i,j,9+d,2,1+k) = theta;

                     tmpx = isnan(SimResults.std(k,:,j,i));
                     tmpx = ~tmpx' & LL_indx;
                     [theta] = MTL([SimResults.b(k,tmpx,j,i)'./SimResults.std(k,tmpx,j,i)', SimResults.b(k,tmpx,j,i)'./SimResults.std(k,tmpx,j,i)'], [1,0;0,1], 1.5, 2,[],[],  Alpha);
                     Output(i,j,9+d,2,21+k) = theta;
                 else
                     Output(i,j,9+d,2,1+k) = NaN;
                     Output(i,j,9+d,2,21+k) = NaN;
                 end
             end
        end
        
     end
end

Output = reshape(Output, [4*13*27*2, 47]);
cd('C:\Users\wbudzinski\Documents\Drawy\Codes') % Directory for files with simulation results

if Alpha == 0.05
    save('MTL_results05.mat','Output','NaNMiss','NaNMiss2', 'NaNno', 'Alpha')
else
    save('MTL_results01.mat','Output','NaNMiss','NaNMiss2', 'NaNno', 'Alpha')
end